
#include "m328Pdef-gcc.inc"

#define _BV(x) (1 << x) ;What is x?

.global main
.section .text

.set SOFTSTOP_PORT, PORTB
.set SOFTSTOP_BIT, PORTB4

.set ESTOP_PORT, PORTB
.set ESTOP_BIT, PORTB5

main:
    call adc_enable ;scroll down
    call pwm_enable ;scroll down

    .read:
    ldi R24, 0
    call adc_read

    ;sbis SOFTSTOP_PORT, SOFTSTOP_BIT
    ;jmp .softstop

    ;sbis ESTOP_PORT, ESTOP_BIT
    ;jmp .estop

    ; Write 50% duty cycle to PWM A
    ldi R24, 0
    ldi R25, 2500 & 0xFF
    ldi R26, 2500 >> 8
    call pwm_write
    ; And PWM B
    ldi R24, 1
    call pwm_write

    rjmp .read

    .softstop:

    ; zero PWM outputs
    ldi R24, 0
    ldi R25, 0
    ldi R26, 0
    call pwm_write
    ldi R24, 1
    call pwm_write

    sbic SOFTSTOP_PORT, SOFTSTOP_BIT
    rjmp .softstop
    rjmp .read

    .estop:
    ; zero PWM outputs
    ldi R24, 0
    ldi R25, 0
    ldi R26, 0
    call pwm_write
    ldi R24, 1
    call pwm_write
    .forever:
    rjmp .forever

; Jams values into ports to control what pins are outputs
; Needs to be way the hell slow (using a count-up mode) for the servo
pwm_enable:
    ; Set PB1&PB2 as outputs
    ;in R16, DDRB
    ldi R16, _BV(DDB1) | _BV(DDB2)
    out DDRD, R16

    

    ; Non-inverting PWM
    ldi ZL, TCCR1A
    ldi ZH, 0x00
    ld R16, Z
    ; _BV(COM1A1) | _BV(COM1B1) | _BV(WGM11) = 
    ; 0b10100010 = 0xA2
    ori R16, 0xA2
    st Z, R16

    ; Prescaler 64, mode 14
    ldi ZL, TCCR1B
    ld R16, Z
    ; _BV(WGM13) | _BV(WGM12) | _BV(CS11) | _BV(CS10) =
    ; 0b00011011 = 0x1B
    ori R16, 0x1B
    st Z, R16

    ; Set total divisor to 64(1+4999) = 320,000
    ; for resultant frequency 16 MHz/320,000 = 50 Hz
    ldi R16, 0x87 ;(4999) & 0xFF
    ldi R17, 0x13; (4999) >> 8
    sts ICR1H, R17
    sts ICR1L, R16
    ret

adc_enable:
    ; Set ADMUX to REFS0
    ldi ZL, ADMUX
    ldi ZH, 0x00
    ldi R16, _BV(REFS0)
    st Z, R16

    ; Read current value of ADCSRA
    ldi ZL, ADCSRA
    ld R16, Z

    ; OR with ADPS2, ADPS0, ADEN, ADFR, ADSC
    ; _BV(ADPS2) | _BV(ADPS0) | _BV(ADEN) = 
    ; 0b10000101 = 0xC5
    ori R16, 0xC5

    ; Write back to ADCSRA
    st Z, R16
    ret

; adc_read
; Parameters:
;   R24 = channel to read
; Returns:
;   R24 = LSB
;   R25 = MSB
adc_read:
    ; Set ADMUX to REFS0 | channel
    ori R24, _BV(REFS0)
    sts ADMUX, R24

    ; Set ADSC in ADCSRA to start conversion
    lds R16, ADCSRA
    ori R16, _BV(ADSC)
    sts ADCSRA, R16

    ; Loop until ADCSRA has the ADIF bit set
    .retry:
    lds R16, ADCSRA
    sbrs R16, ADIF
    rjmp .retry

    ; Set ADIF to clear
    lds R16, ADCSRA
    ori R16, _BV(ADIF)
    sts ADCSRA, R16

    ; Read value from ADC port
    lds R24, ADCL
    lds R25, ADCH
    ret

; pwm_write
; Parameters:
;   R24 = pin on timer B (0 or 1)
;   R25 = LSB
;   R26 = MSB
pwm_write:
    subi R24, 1
    breq .port_1

    .port_0:
    sts OCR1AH, R26
    sts OCR1AL, R25
    ret

    .port_1:
    sts OCR1BH, R26
    sts OCR1BL, R25
    ret
